#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_TestingStatus : BaseTest 
	{
		
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
		}
		
		[Test]
		public void GetTestingStatusTextFromID_Pass()
		{
			string testingStatusText;

			for (int i = 1; i <=3; i++)
			{
				testingStatusText= TestingStatus.GetTestingStatusTextFromID(i);
				Assert.IsTrue(testingStatusText.Length > 0, "Testing status id of " + i.ToString() + "brings back nothing");
			}
		}

		[Test]
		public void GetTestingStatusTextFromID_Fail()
		{
			string testingStatusText;
			testingStatusText= TestingStatus.GetTestingStatusTextFromID(int.MinValue);
			Assert.IsTrue(testingStatusText == string.Empty);
			testingStatusText= TestingStatus.GetTestingStatusTextFromID(0);
			Assert.IsTrue(testingStatusText == string.Empty);
		}

		[Test]
		public void GetTestingStatusLookupDataTable_Pass()
		{
			DataTable dtTest = BOL.TestingStatus.GetTestingStatusLookupDataTable();
			Assert.IsNotNull(dtTest);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTestingStatusLookupDataTable_Fail()
		{
		}

		[Test]
		public void GetTestingStatusLookupList_Pass()
		{
			System.Collections.ArrayList alTest = BOL.TestingStatus.GetTestingStatusLookupList();
			Assert.IsNotNull(alTest);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetTestingStatusLookupList_Fail()
		{
		}

	}

}
#endif


